using System;
using System.Web;
using System.Web.Management;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Text;

namespace SampleEvents
{
   public class AsyncSearchWebEvent : WebBaseEvent
   {
      private DateTime timeRaised;
      private string searchCriteria = string.Empty;

      public AsyncSearchWebEvent(string message,
         object eventSource,
         int eventCode)
         : base(message, eventSource, eventCode)
      {
      }

      public override void Raise()
      {
         timeRaised = DateTime.Now;
         base.Raise();
      }

      public override void FormatCustomEventDetails(WebEventFormatter formatter)
      {
         formatter.AppendLine("");
         formatter.IndentationLevel += 1;
         formatter.AppendLine("-- Dane Niestandardowego Zdarzenia --");
         formatter.AppendLine(string.Format("Kryteria wyszukiwania: {0}",
            searchCriteria));
         formatter.AppendLine(string.Format("Czas wystpienia zdarzenia: {0}",
            timeRaised.ToString()));
         formatter.IndentationLevel -= 1;
      }

      public DateTime TimeRaised
      {
         get { return timeRaised; }
         set { timeRaised = value; }
      }

      public string SearchCriteria
      {
         get { return searchCriteria; }
         set { searchCriteria = value; }
      }
   }
}
